/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.pit;

import dioscuri.module.pit.PIT;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Counter {
    private PIT pit;
    private int counterNumber;
    private boolean signalClock;
    private boolean signalGate;
    private boolean signalOut;
    protected int counterMode;
    protected int rwMode;
    protected boolean bcd;
    protected byte[] ce;
    protected byte[] cr;
    protected byte[] ol;
    private boolean isEnabled;
    private boolean parity;
    private boolean lsbWritten;
    private boolean lsbRead;
    private boolean isLatched;
    private boolean newCount;
    private boolean isTriggered;
    private boolean isGateRising;
    protected boolean readBackCmd;
    private static final Logger logger = Logger.getLogger(Counter.class.getName());
    protected static final int LSB = 1;
    protected static final int MSB = 0;
    private static final boolean ODD = false;
    private static final boolean EVEN = true;
    private static final boolean BINARY = false;
    private static final boolean BCD = true;
    private static final int RWMODE_0 = 0;
    private static final int RWMODE_1 = 1;
    private static final int RWMODE_2 = 2;
    private static final int RWMODE_3 = 3;
    private static final int COUNTERMODE_0 = 0;
    private static final int COUNTERMODE_1 = 1;
    private static final int COUNTERMODE_2 = 2;
    private static final int COUNTERMODE_3 = 3;
    private static final int COUNTERMODE_4 = 4;
    private static final int COUNTERMODE_5 = 5;

    public Counter(PIT pIT, int n) {
        this.pit = pIT;
        this.counterNumber = n;
        this.signalClock = false;
        this.signalGate = true;
        this.signalOut = true;
        this.rwMode = 0;
        this.counterMode = 2;
        this.bcd = false;
        this.ce = new byte[]{0, 0};
        this.cr = new byte[]{0, 0};
        this.ol = new byte[]{0, 0};
        this.isEnabled = false;
        this.parity = true;
        this.lsbWritten = false;
        this.lsbRead = false;
        this.isLatched = false;
        this.newCount = false;
        this.isTriggered = false;
        this.isGateRising = false;
    }

    public void clockPulse() {
        block73: {
            block74: {
                if (!this.isEnabled) break block73;
                if (this.bcd) break block74;
                switch (this.counterMode) {
                    case 0: {
                        if (this.newCount) {
                            this.loadCounter();
                            this.newCount = false;
                            this.pit.lowerIRQ(this);
                            break;
                        }
                        if (this.signalGate) {
                            this.ce[1] = (byte)(this.ce[1] - 1);
                            if (this.rwMode == 1) {
                                if (this.ce[1] == 0) {
                                    this.signalOut = true;
                                    this.pit.raiseIRQ(this);
                                    break;
                                }
                            } else {
                                if (this.rwMode == 2) {
                                    logger.log(Level.WARNING, "[" + (Object)((Object)this.pit.getType()) + "] counter " + this.counterNumber + " countermode0 r/wmode2 not implemented.");
                                    break;
                                }
                                if (this.rwMode == 3) {
                                    if (this.ce[1] == -1) {
                                        this.ce[0] = (byte)(this.ce[0] - 1);
                                        break;
                                    }
                                    if (this.ce[1] == 0 && this.ce[0] == 0) {
                                        this.signalOut = true;
                                        this.pit.raiseIRQ(this);
                                        break;
                                    }
                                }
                            }
                        }
                        break block73;
                    }
                    case 1: {
                        if (this.isGateRising) {
                            this.loadCounter();
                            this.newCount = false;
                            this.isTriggered = true;
                            this.signalOut = false;
                            this.pit.lowerIRQ(this);
                            break;
                        }
                        if (this.isTriggered) {
                            this.ce[1] = (byte)(this.ce[1] - 1);
                            if (this.rwMode == 1) {
                                if (this.ce[1] == 0) {
                                    this.signalOut = true;
                                    this.pit.raiseIRQ(this);
                                    break;
                                }
                            } else {
                                if (this.rwMode == 2) {
                                    logger.log(Level.WARNING, "[" + (Object)((Object)this.pit.getType()) + "] counter " + this.counterNumber + " countermode1 r/wmode2 not implemented.");
                                    break;
                                }
                                if (this.rwMode == 3) {
                                    if (this.ce[1] == -1) {
                                        this.ce[0] = (byte)(this.ce[0] - 1);
                                        break;
                                    }
                                    if (this.ce[1] == 0 && this.ce[0] == 0) {
                                        this.signalOut = true;
                                        this.pit.raiseIRQ(this);
                                        break;
                                    }
                                }
                            }
                        }
                        break block73;
                    }
                    case 2: {
                        this.signalOut = true;
                        if (this.newCount) {
                            this.loadCounter();
                            this.newCount = false;
                            this.pit.lowerIRQ(this);
                            break;
                        }
                        if (this.signalGate) {
                            this.ce[1] = (byte)(this.ce[1] - 1);
                            if (this.rwMode == 1) {
                                if (this.ce[1] == 1) {
                                    this.signalOut = false;
                                    logger.log(Level.CONFIG, "[" + (Object)((Object)this.pit.getType()) + "] counter " + this.counterNumber + " countermode2 r/wmode1 expired.");
                                    this.pit.raiseIRQ(this);
                                    this.newCount = true;
                                    break;
                                }
                            } else {
                                if (this.rwMode == 2) {
                                    logger.log(Level.WARNING, "[" + (Object)((Object)this.pit.getType()) + "] counter " + this.counterNumber + " countermode2 r/wmode2 not implemented.");
                                    break;
                                }
                                if (this.rwMode == 3) {
                                    if (this.ce[1] == -1) {
                                        this.ce[0] = (byte)(this.ce[0] - 1);
                                        break;
                                    }
                                    if (this.ce[1] == 1 && this.ce[0] == 0) {
                                        this.signalOut = false;
                                        logger.log(Level.CONFIG, "[" + (Object)((Object)this.pit.getType()) + "] counter " + this.counterNumber + " countermode2 r/wmode3 expired.");
                                        this.pit.raiseIRQ(this);
                                        this.newCount = true;
                                        break;
                                    }
                                }
                            }
                        }
                        break block73;
                    }
                    case 3: {
                        if (this.newCount) {
                            this.loadCounter();
                            this.pit.lowerIRQ(this);
                            if (!this.parity) {
                                this.ce[1] = (byte)(this.ce[1] - 1);
                                if (this.signalOut) {
                                    this.signalOut = false;
                                }
                            }
                            this.newCount = false;
                            break;
                        }
                        if (this.signalGate) {
                            this.ce[1] = (byte)(this.ce[1] - 1);
                            this.ce[1] = (byte)(this.ce[1] - 1);
                            if (this.rwMode == 1) {
                                if (this.ce[1] == 0) {
                                    this.pit.raiseIRQ(this);
                                    if (this.signalOut && this.parity) {
                                        this.signalOut = false;
                                    } else if (!this.signalOut) {
                                        this.signalOut = true;
                                    }
                                    this.newCount = true;
                                    break;
                                }
                            } else {
                                if (this.rwMode == 2) {
                                    logger.log(Level.WARNING, "[" + (Object)((Object)this.pit.getType()) + "] counter " + this.counterNumber + " countermode3 r/wmode2 not implemented.");
                                    break;
                                }
                                if (this.rwMode == 3) {
                                    if (this.ce[1] == -2) {
                                        this.ce[0] = (byte)(this.ce[0] - 1);
                                        break;
                                    }
                                    if (this.ce[1] == 0 && this.ce[0] == 0) {
                                        logger.log(Level.CONFIG, "[" + (Object)((Object)this.pit.getType()) + "] counter " + this.counterNumber + " countermode3 r/wmode3 expired.");
                                        this.pit.raiseIRQ(this);
                                        if (this.parity) {
                                            if (this.signalOut) {
                                                this.signalOut = false;
                                            } else if (!this.signalOut) {
                                                this.signalOut = true;
                                            }
                                        } else if (!this.signalOut) {
                                            this.signalOut = true;
                                        }
                                        this.newCount = true;
                                        break;
                                    }
                                }
                            }
                        }
                        break block73;
                    }
                    case 4: {
                        this.signalOut = true;
                        if (this.newCount) {
                            this.loadCounter();
                            this.newCount = false;
                            this.pit.lowerIRQ(this);
                            break;
                        }
                        if (this.signalGate) {
                            this.ce[1] = (byte)(this.ce[1] - 1);
                            if (this.rwMode == 1) {
                                if (this.ce[1] == 0) {
                                    this.signalOut = false;
                                    this.pit.raiseIRQ(this);
                                    this.newCount = true;
                                    break;
                                }
                            } else {
                                if (this.rwMode == 2) {
                                    logger.log(Level.WARNING, "[" + (Object)((Object)this.pit.getType()) + "] counter " + this.counterNumber + " countermode4 r/wmode2 not implemented.");
                                    break;
                                }
                                if (this.rwMode == 3) {
                                    if (this.ce[1] == -1) {
                                        this.ce[0] = (byte)(this.ce[0] - 1);
                                        break;
                                    }
                                    if (this.ce[1] == 0 && this.ce[0] == 0) {
                                        this.signalOut = false;
                                        this.pit.raiseIRQ(this);
                                        this.newCount = true;
                                        break;
                                    }
                                }
                            }
                        }
                        break block73;
                    }
                    case 5: {
                        this.signalOut = true;
                        if (this.isGateRising) {
                            this.loadCounter();
                            this.newCount = false;
                            this.isTriggered = true;
                            this.pit.lowerIRQ(this);
                            break;
                        }
                        if (this.isTriggered) {
                            this.ce[1] = (byte)(this.ce[1] - 1);
                            if (this.rwMode == 1) {
                                if (this.ce[1] == 0) {
                                    this.signalOut = false;
                                    this.pit.raiseIRQ(this);
                                    break;
                                }
                            } else {
                                if (this.rwMode == 2) {
                                    logger.log(Level.WARNING, "[" + (Object)((Object)this.pit.getType()) + "] counter " + this.counterNumber + " countermode5 r/wmode2 not implemented.");
                                    break;
                                }
                                if (this.rwMode == 3) {
                                    if (this.ce[1] == -1) {
                                        this.ce[0] = (byte)(this.ce[0] - 1);
                                        break;
                                    }
                                    if (this.ce[1] == 0 && this.ce[0] == 0) {
                                        this.signalOut = false;
                                        this.pit.raiseIRQ(this);
                                        break;
                                    }
                                }
                            }
                        }
                        break block73;
                    }
                    default: {
                        logger.log(Level.WARNING, "[" + (Object)((Object)this.pit.getType()) + "] counter " + this.counterNumber + " no countermode match.");
                        break;
                    }
                }
                break block73;
            }
            logger.log(Level.WARNING, "[" + (Object)((Object)this.pit.getType()) + "] counter " + this.counterNumber + " BCD counting not implemented.");
        }
        this.isGateRising = false;
    }

    protected boolean getGateSignal() {
        return this.signalGate;
    }

    protected void setGateSignal(boolean bl) {
        if (bl) {
            this.isGateRising = !this.signalGate;
        } else if (this.signalGate && (this.counterMode == 2 || this.counterMode == 3) && !this.signalOut) {
            this.signalOut = true;
            this.pit.raiseIRQ(this);
        }
        this.signalGate = bl;
    }

    protected boolean getOutSignal() {
        return this.signalOut;
    }

    protected byte getCounterValue() {
        if (this.readBackCmd) {
            this.readBackCmd = false;
        } else {
            if (this.rwMode == 0) {
                if (this.lsbRead) {
                    this.lsbRead = false;
                    this.isLatched = false;
                    return this.ol[0];
                }
                this.lsbRead = true;
                return this.ol[1];
            }
            if (this.rwMode == 1) {
                return this.ce[1];
            }
            if (this.rwMode == 2) {
                return this.ce[0];
            }
            if (this.rwMode == 3) {
                if (this.lsbRead) {
                    this.lsbRead = false;
                    return this.ce[0];
                }
                this.lsbRead = true;
                return this.ce[1];
            }
        }
        return 0;
    }

    protected void setCounterValue(byte by) {
        if (this.rwMode != 0) {
            if (this.rwMode == 1) {
                this.cr[1] = by;
                this.newCount = true;
                if (this.isEnabled) {
                    logger.log(Level.CONFIG, "[" + (Object)((Object)this.pit.getType()) + "] Counter is already in use. Resetting may cause timing issues.");
                }
                this.isEnabled = true;
            } else if (this.rwMode == 2) {
                this.cr[0] = by;
                this.newCount = true;
                if (this.isEnabled) {
                    logger.log(Level.CONFIG, "[" + (Object)((Object)this.pit.getType()) + "] Counter is already in use. Resetting may cause timing issues.");
                }
                this.isEnabled = true;
            } else if (this.rwMode == 3) {
                if (this.lsbWritten) {
                    this.cr[0] = by;
                    this.lsbWritten = false;
                    this.newCount = true;
                } else {
                    this.cr[1] = by;
                    this.lsbWritten = true;
                }
                if (this.isEnabled) {
                    logger.log(Level.CONFIG, "[" + (Object)((Object)this.pit.getType()) + "] Counter is already in use. Resetting may cause timing issues.");
                }
                this.isEnabled = true;
            }
        }
    }

    protected void setCounterMode(int n) {
        this.counterMode = n;
        if (this.counterMode == 6) {
            this.counterMode = 2;
        } else if (this.counterMode == 7) {
            this.counterMode = 3;
        }
        if (this.counterMode == 0) {
            this.signalGate = true;
            this.signalOut = false;
        } else if (this.counterMode == 1) {
            this.signalGate = false;
            this.signalOut = true;
        } else if (this.counterMode == 2) {
            this.signalGate = true;
            this.signalOut = true;
        } else if (this.counterMode == 3) {
            this.signalGate = true;
            this.signalOut = true;
        } else if (this.counterMode == 4) {
            this.signalGate = true;
            this.signalOut = true;
        } else if (this.counterMode == 5) {
            this.signalGate = false;
            this.signalOut = true;
        }
    }

    protected void latchCounter() {
        if (this.isLatched) {
            logger.log(Level.WARNING, "[" + (Object)((Object)this.pit.getType()) + "] Counter already latched, cannot latch");
        } else {
            this.ol[1] = this.ce[1];
            this.ol[0] = this.ce[0];
            this.isLatched = true;
        }
    }

    private void loadCounter() {
        if (this.rwMode == 1) {
            this.ce[1] = this.cr[1];
            this.ce[0] = 0;
        } else if (this.rwMode == 2) {
            this.ce[1] = 0;
            this.ce[0] = this.cr[0];
        } else if (this.rwMode == 3) {
            this.ce[1] = this.cr[1];
            this.ce[0] = this.cr[0];
        }
        this.parity = (((this.ce[0] & 0xFF) << 8) + (this.ce[1] & 0xFF)) % 2 == 0;
    }

    protected boolean getParity() {
        return this.parity;
    }

    protected boolean getBCD() {
        return this.bcd;
    }

    protected void setEnabled(boolean bl) {
        this.isEnabled = bl;
    }

    protected boolean isEnabled() {
        return this.isEnabled;
    }

    protected int getCounterNumber() {
        return this.counterNumber;
    }
}

